<?php

$stock_qty_check = get_option( 'stock_qty_check' );
if($stock_qty_check == 'yes'){
	require_once 'includes/product-type.php';
}

$extra_field_check = get_option( 'extra_field_check' );
if($extra_field_check == 'yes'){
	require_once 'includes/product-option-page-woo.php';
}

$image_preview_order = get_option( 'image_preview_order' );
if($image_preview_order == 'yes'){
    require_once 'includes/checkout-image-preview-order.php';
}

$nav_prev_next = get_option( 'nav_prev_next' );
if($nav_prev_next == 'yes'){
    require_once 'includes/product-nav-prev-next.php';
} 

add_action( 'admin_menu', 'tk_options_menu_admin' );
 
function tk_options_menu_admin(){
 
    add_menu_page(
        'Themes kingdom - Features',
        'Themes kingdom',
        'manage_options',
        'themes_kingdom',
        'themes_kingdom_page_callback',
        'dashicons-admin-settings',
        3
    );

}

function themes_kingdom_page_callback(){
    ?>
        <div class="wrap theme-option">
            <div class="theme-option-wrapper">
                <div class="theme-option-head">
                    <h1><?php echo get_admin_page_title() ?></h1>
                </div>
                <div class="tk_theme-option-content">
                    <form method="post" action="options.php">
                        <div class="tho-inner">
                            <?php
                                settings_fields( 'themes_kingdom_settings' ); 
                                do_settings_sections( 'themes_kingdom' );
                            ?>
                        </div>
                        <p class="submit btn-wrap">
                            <input name="Submit" type="submit" class="button-primary" value="<?php esc_attr_e('Save changes'); ?>" />
                        </p>
                    </form>
                </div>
            </div>
        </div>
        <style type="text/css">
            /*.theme-option{
                padding: 0 15px;
                margin-top: 70px;
                position: relative;
             }
             .theme-option .notice{
                position: absolute !important;
                top: -52px;
                left: 0;
             }
             .theme-option-wrapper {
                background-color: #fff;
                border-radius: 5px;
                box-shadow: 0 2px 2px #ced4da;
                border: 1px solid #ced4da;
                border-left: 3px solid #2271b1;
            }
            .theme-option-head{
                border-bottom: 1px solid #ced4da;
                text-align: left;
                position: relative;
                display: -webkit-box;
                display: -ms-flexbox;
                display: flex;
                -webkit-box-align: center;
                -ms-flex-align: center;
                align-items: center;
                padding: 15px;
            }*/
            .tk_theme-option-content{
                margin-top: 30px;
                background-color: #fff;
                border-radius: 5px;
                box-shadow: 0 2px 2px #ced4da;
                border: 1px solid #ced4da;
                border-left: 3px solid #2271b1;
            }
            .tk_theme-option-content .tho-inner{
                padding: 20px 40px;
            }
            .btn-wrap{
                border-top: 1px solid #ced4da;
                padding: 15px 40px !important;
                margin-top: 0px !important;
                margin-bottom: 0px !important;
            }
            .btn-wrap .button-primary{
                padding: 4px 16px;
                background: transparent;
                color: #007cba;
                white-space: nowrap;
                outline: 1px solid transparent;
                border-radius: 5px;
            }
            .btn-wrap .button-primary:focus{
                box-shadow: unset;
            }
            .btn-wrap .button-primary:hover{
                background: transparent;
                color: #007cba;
            }
            .theme-option .form-table{
                margin-top: 0px;
            }
            .theme-option .form-table tbody tr{
                display: flex;
                align-items: center;
                flex-direction: row-reverse;
                justify-content: start;
                margin-bottom: 25px;
                width: 100%;
            }
            .theme-option .form-table tbody tr:last-child{
                margin-bottom: 0;
            }
            .theme-option .form-table tbody tr th label{
                font-size: 16px;
            }
            .theme-option .form-table tbody tr th p{
                margin: 0;
                font-weight: 400;
            }
            .theme-option .form-table th{
                width: 450px;
                padding: 0;
            }
            .theme-option .form-table td{
                padding: 0;
                line-height: 0;
                margin-bottom: 0;
            }
            .switch-wrap{
                margin-right: 20px;
            }
            .switch-wrap input[type=checkbox]{
                height: 0;
                width: 0;
                visibility: hidden;
            }
            .switch-wrap label {
                cursor: pointer;
                text-indent: -9999px;
                width: 60px;
                height: 30px;
                background: #dcdcde;
                display: block;
                border-radius: 100px;
                position: relative;
            }
            .switch-wrap label:after {
                content: '';
                position: absolute;
                top: 5px;
                left: 5px;
                width: 20px;
                height: 20px;
                background: #fff;
                border-radius: 50px;
                transition: 0.3s;
            }
            .switch-wrap input:checked + label {
                background: #2271b1;
            }

            .switch-wrap input:checked + label:after {
                left: calc(100% - 5px);
                transform: translateX(-100%);
            }
            .switch-wrap label:active:after {
                width: 20px;
            }
        </style>  
        <script type="text/javascript"> 
        jQuery(document).ready(function(){
            jQuery( ".extra_field_check th label" ).after( "<p>Add Swiper library to the gallery thumbnail slider.</p>" );
            jQuery( ".stock_qty_check th label" ).after( "<p>Add column to identify product type.</p>" );
            jQuery( ".image_preview_order th label" ).after( "<p>Add image preview order in Checkout (WooCommerce Classic Checkout).</p>" );
            jQuery( ".nav_prev_next th label" ).after( "<p>Add navigation buttons (Next, Previous) in single product.</p>" );
        });
        </script>
    <?php
}

add_action( 'admin_init',  'rudr_settings_fields' );
function rudr_settings_fields(){

    $page_slug = 'themes_kingdom';
    $option_group = 'themes_kingdom_settings';

    // 1. create section
    add_settings_section('extra_field_check_section_id', '', '', $page_slug);

    // 2. register fields
    register_setting( $option_group, 'extra_field_check', 'extra_field_sanitize_checkbox' );
    register_setting( $option_group, 'stock_qty_check', 'extra_field_sanitize_checkbox' );
    register_setting( $option_group, 'image_preview_order', 'extra_field_sanitize_checkbox' );
    register_setting( $option_group, 'nav_prev_next', 'extra_field_sanitize_checkbox' );
   
   
    // 3. add fields
    add_settings_field(
        'extra_field_check',
        'Product Gallery',
        'extra_field_checkbox', 
        $page_slug,
        'extra_field_check_section_id',
        array ( 
            'label_for' => 'extra_field_check',
            'class' => 'extra_field_check',
        )
    );

    add_settings_field(
        'stock_qty_check',
        'Column Product Type.',
        'stock_qty_checkbox', 
        $page_slug,
        'extra_field_check_section_id',
        array ( 
            'label_for' => 'stock_qty_check',
            'class' => 'stock_qty_check',
        ) 
    );

    add_settings_field(
        'image_preview_order',
        'Image Preview Order.',
        'tk_image_preview_order', 
        $page_slug,
        'extra_field_check_section_id',
        array ( 
            'label_for' => 'image_preview_order',
            'class' => 'image_preview_order',
        ) 
    );

    add_settings_field(
        'nav_prev_next',
        'Navigation Buttons (Next, Previous).',
        'tk_nav_prev_next', 
        $page_slug,
        'extra_field_check_section_id',
        array ( 
            'label_for' => 'nav_prev_next',
            'class' => 'nav_prev_next',
        ) 
    );
}

function extra_field_checkbox( $args ) {
    $value = get_option( 'extra_field_check' );
    ?>
    <div class="switch-wrap">
        <input type="checkbox" id="extraswitch" name="extra_field_check" <?php checked( $value, 'yes' ) ?> /> 
        <label for="extraswitch">Yes</label>
    </div>
    <?php
}

function stock_qty_checkbox( $args ) {
    $value = get_option( 'stock_qty_check' );
    ?>
    <div class="switch-wrap">
        <input type="checkbox" id="stockqtyswitch" name="stock_qty_check" <?php checked( $value, 'yes' ) ?> /> 
        <label for="stockqtyswitch">Yes</label>
    </div>
    <?php
}

function tk_image_preview_order( $args ) {
    $value = get_option( 'image_preview_order' );
    ?>
    <div class="switch-wrap">
        <input type="checkbox" id="imgprevorderswitch" name="image_preview_order" <?php checked( $value, 'yes' ) ?> /> 
        <label for="imgprevorderswitch">Yes</label>
    </div>
    <?php
}

function tk_nav_prev_next( $args ) {
    $value = get_option( 'nav_prev_next' );
    ?>
    <div class="switch-wrap">
        <input type="checkbox" id="navprevnextswitch" name="nav_prev_next" <?php checked( $value, 'yes' ) ?> /> 
        <label for="navprevnextswitch">Yes</label>
    </div>
    <?php
}

function extra_field_sanitize_checkbox( $value ) {
    return 'on' === $value ? 'yes' : 'no';
}

add_action( 'admin_notices', 'tk_options_notice' );

function tk_options_notice() {

    if(
        isset( $_GET[ 'page' ] ) 
        && 'themes_kingdom' == $_GET[ 'page' ]
        && isset( $_GET[ 'settings-updated' ] ) 
        && true == $_GET[ 'settings-updated' ]
    ) {
        ?>
            <div class="notice notice-success is-dismissible">
                <p>
                    <strong>Saved Page Settings.</strong>
                </p>
            </div>
        <?php
    }

}