<?php
// Add navigation buttons (Next, Previous) in single product

if ( ! class_exists( 'TK_WooCommerce_Adjacent_Products' ) ) :

    class TK_WooCommerce_Adjacent_Products {

        private $current_product = null;

        private $in_same_term = false;

        private $excluded_terms = '';

        private $taxonomy = 'product_cat';

        private $previous = false;

        public function __construct( $in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat', $previous = false ) {
            $this->in_same_term   = $in_same_term;
            $this->excluded_terms = $excluded_terms;
            $this->taxonomy       = $taxonomy;
            $this->previous       = $previous;
        }

        public function get_product() {
            global $post;

            $product               = false;
            $this->current_product = $post->ID;

            while ( $adjacent = $this->get_adjacent() ) {
                $product = wc_get_product( $adjacent->ID );

                if ( $product && $product->is_visible() ) {
                    break;
                }

                $product               = false;
                $this->current_product = $adjacent->ID;
            }

            if ( $product ) {
                return $product;
            }

            $product = $this->query_wc();

            if ( $product ) {
                return $product;
            }

            return false;
        }

        private function get_adjacent() {
            global $post;

            $direction = $this->previous ? 'previous' : 'next';

            add_filter( 'get_' . $direction . '_post_where', array( $this, 'filter_post_where' ) );

            $adjacent = get_adjacent_post( $this->in_same_term, $this->excluded_terms, $this->previous, $this->taxonomy );

            remove_filter( 'get_' . $direction . '_post_where', array( $this, 'filter_post_where' ) );

            return $adjacent;
        }

        public function filter_post_where( $where ) {
            global $post;

            $new = get_post( $this->current_product );

            $where = str_replace( $post->post_date, $new->post_date, $where );

            return $where;
        }
 
        private function query_wc() {
            global $post;

            $args = array(
                'limit'      => 2,
                'visibility' => 'catalog',
                'exclude'    => array( $post->ID ),
                'orderby'    => 'date',
                'status'     => 'publish',
            );

            if ( ! $this->previous ) {
                $args['order'] = 'ASC';
            }

            if ( $this->in_same_term ) {
                $terms = get_the_terms( $post->ID, $this->taxonomy );

                if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
                    $args['category'] = wp_list_pluck( $terms, 'slug' );
                }
            }

            $products = wc_get_products( apply_filters( 'tk_woocommerce_adjacent_query_args', $args ) );

            // At least 2 results are required, otherwise previous/next will be the same.
            if ( ! empty( $products ) && count( $products ) >= 2 ) {
                return $products[0];
            }

            return false;
        }
    }

endif;

add_action('woocommerce_before_single_product', 'tk_product_navigation_links',200);

function tk_product_navigation_links() {

    global $post;

    //$prev_product_id = get_adjacent_post(true, '', true, 'product_cat');
    //$next_product_id = get_adjacent_post(true, '', false, 'product_cat');

    function tk_get_previous_product( $in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat' ) {
        $product = new TK_WooCommerce_Adjacent_Products( $in_same_term, $excluded_terms, $taxonomy, true );
        return $product->get_product();
    }

    function tk_get_next_product( $in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat' ) {
        $product = new TK_WooCommerce_Adjacent_Products( $in_same_term, $excluded_terms, $taxonomy );
        return $product->get_product();
    }

    $in_same_term   = apply_filters( 'tk_single_product_pagination_same_category', true );
    $excluded_terms = apply_filters( 'tk_single_product_pagination_excluded_terms', '' );
    $taxonomy       = apply_filters( 'tk_single_product_pagination_taxonomy', 'product_cat' );

    $prev_product_id = tk_get_previous_product( $in_same_term, $excluded_terms, $taxonomy );
    $next_product_id = tk_get_next_product( $in_same_term, $excluded_terms, $taxonomy );

    if ( ! $prev_product_id && ! $next_product_id ) {
        return;
    }

    ?>

    <div class="tk_prev_next_buttons custom_links_woo">
        <span class='tk_prev_product_button'>
        <?php if ( $prev_product_id ) : ?>
            <a href="<?php echo esc_url( $prev_product_id->get_permalink() ); ?>">&larr; PREVIOUS</a>
        <?php endif; ?>
        </span>

        <span class='tk_next_product_button'>

        <?php if ( $next_product_id ) : ?>
            <a href="<?php echo esc_url( $next_product_id->get_permalink() ); ?>">NEXT &rarr;</a>
        <?php endif; ?>
        </span>

    </div>

    <?php
}

add_filter( 'tk_single_product_pagination_same_category','custom_tk_single_product_pagination_same_category');
function custom_tk_single_product_pagination_same_category($is_same=true){
    if($is_same){
        return false;
    }
}

add_action('wp_head', 'tk_single_product_nav_css');

function tk_single_product_nav_css(){
    ?>
    <style>
        .tk_prev_next_buttons{
            position: relative;
            margin-bottom: 50px;
        }
        .tk_prev_next_buttons:after{
            content: "";
            clear: both;
            display: table;
        }
        .tk_prev_product_button{
            float: left;
        }
        .tk_next_product_button{
            float: right;
        }
    </style>
    <?php
}