<?php

function goodz_shop_child_enqueue_styles()
{

	$parent_style = 'goodz-style';

	wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
	wp_enqueue_style(
		'child-style',
		get_stylesheet_directory_uri() . '/style.css',
		array($parent_style),
		wp_get_theme()->get('Version')
	);
}
add_action('wp_enqueue_scripts', 'goodz_shop_child_enqueue_styles');

function theme_setup()
{
	add_filter('wpcf7_autop_or_not', '__return_false');
}
add_action('after_setup_theme', 'theme_setup');


add_action('wp_footer', 'script_products_grid');

function script_products_grid() {
    if(is_shop() || is_product_category()) {
        ?>
        <script>
            const buttons = document.querySelectorAll('.buttons-grid .wp-block-button');
            if (buttons) {
                buttons.forEach(button => {
                    button.addEventListener('click', () => {
                        buttons.forEach(x => x.classList.remove('active'));
                        button.classList.add('active');
                    })
                });
            }
        </script>
        <?php
    }
}

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require_once get_stylesheet_directory() . '/inc/template-functions.php';

/**
 * Disable Responsive Images
 */

add_filter( 'wp_calculate_image_srcset', '__return_false' );

/**
 * Improvements
 */

require get_stylesheet_directory() . '/inc/features/load-features.php';


// Set up import files for Merlin
function merlin_local_import_files() {
	return array(
		array(
			'import_file_name'             => 'Demo',
			'local_import_file'            => get_stylesheet_directory() . '/inc/import/content.xml',
			'local_import_widget_file'     => get_stylesheet_directory() . '/inc/import/widgets.wie',
			'local_import_customizer_file' => get_stylesheet_directory() . '/inc/import/customizer.dat',
			'import_preview_image_url'     => '',
			'import_notice'                => __( 'Thank you!', 'phenomena' ),
			'preview_url'                  => 'http://themeskingdom.com/',
		),
	);
}
add_filter( 'merlin_import_files', 'merlin_local_import_files' );


remove_action( 'tgmpa_register', 'goodz_register_slider_plugin' );

if ( ! function_exists( 'goodz_register_slider_plugin' ) ) {
    function goodz_register_slider_plugin() {
        $plugins = array(
            array(
                'name'               => esc_html__( 'TK Custom Post Types', 'goodz' ), // The plugin name
                'slug'               => 'goodz-custom-post-types', // The plugin slug (typically the folder name)
                'source'             => 'https://s3-eu-west-1.amazonaws.com/tk-public-downloads/goodz-custom-post-types.zip', // The plugin source
                'required'           => true, // If false, the plugin is onl    y 'recommended' instead of required
                'version'            => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
                'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
                'force_deactivation' => true, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
                'external_url'       => 'http://www.themeskingdom.com', // If set, overrides default API URL and points to an external URL
            ),
            array(
                'name'               => esc_html__( 'WooCommerce', 'goodz' ), // The plugin name
                'slug'               => 'woocommerce', // The plugin slug (typically the folder name)
                'required'           => false, // If false, the plugin is onl    y 'recommended' instead of required
            ),
			array(
                'name'               => esc_html__( 'YITH WooCommerce Wishlist', 'goodz' ), // The plugin name
                'slug'               => 'yith-woocommerce-wishlist', // The plugin slug (typically the folder name)
                'required'           => false, // If false, the plugin is onl    y 'recommended' instead of required
            ),
            array(
                'name'               => esc_html__( 'Contact Form 7', 'goodz' ), // The plugin name
                'slug'               => 'contact-form-7', // The plugin slug (typically the folder name)
                'required'           => false, // If false, the plugin is only 'recommended' instead of required
            ),
            array(
                'name'               => esc_html__( 'Spectra Gutenberg Blocks', 'goodz' ), // The plugin name
                'slug'               => 'ultimate-addons-for-gutenberg',
                'required'           => false
            ),
        );

        $config = array(
            'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to bundled plugins.
            'menu'         => 'tgmpa-install-plugins', // Menu slug.
            'parent_slug'  => 'themes.php',            // Parent menu slug.
            'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
            'has_notices'  => true,                    // Show admin notices or not.
            'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => false,                   // Automatically activate plugins after installation or not.
            'message'      => '',                      // Message to output right before the plugins table.
        );
        goodz_fse_tgmpa( $plugins, $config );
    } // function
    add_action( 'tgmpa_register', 'goodz_register_slider_plugin' );
} // if

if ( ! function_exists( 'goodz_fse_tgmpa' ) ) {
	/**
	 * Helper function to register a collection of required plugins.
	 *
	 * @since 2.0.0
	 * @api
	 *
	 * @param array $plugins An array of plugin arrays.
	 * @param array $config  Optional. An array of configuration values.
	 */
	function goodz_fse_tgmpa( $plugins, $config = array() ) {
		$instance = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );

		foreach ( $plugins as $plugin ) {
			call_user_func( array( $instance, 'register' ), $plugin );
		}

		if ( ! empty( $config ) && is_array( $config ) ) {
			// Send out notices for deprecated arguments passed.
			if ( isset( $config['notices'] ) ) {
				_deprecated_argument( __FUNCTION__, '2.2.0', 'The `notices` config parameter was renamed to `has_notices` in TGMPA 2.2.0. Please adjust your configuration.' );
				if ( ! isset( $config['has_notices'] ) ) {
					$config['has_notices'] = $config['notices'];
				}
			}

			if ( isset( $config['parent_menu_slug'] ) ) {
				_deprecated_argument( __FUNCTION__, '2.4.0', 'The `parent_menu_slug` config parameter was removed in TGMPA 2.4.0. In TGMPA 2.5.0 an alternative was (re-)introduced. Please adjust your configuration. For more information visit the website: http://tgmpluginactivation.com/configuration/#h-configuration-options.' );
			}
			if ( isset( $config['parent_url_slug'] ) ) {
				_deprecated_argument( __FUNCTION__, '2.4.0', 'The `parent_url_slug` config parameter was removed in TGMPA 2.4.0. In TGMPA 2.5.0 an alternative was (re-)introduced. Please adjust your configuration. For more information visit the website: http://tgmpluginactivation.com/configuration/#h-configuration-options.' );
			}

			call_user_func( array( $instance, 'config' ), $config );
		}
	}
}