<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.me/
 *
 * @package Goodz
 */

function goodz_jetpack_setup() {
	/**
	 * Add theme support for Responsive videos.
	 */
	add_theme_support( 'jetpack-responsive-videos' );

	/**
	 * Add theme support for Site Logo
	 */
	add_theme_support( 'site-logo', array(
	    'size' => 'goodz-shop-logo',
	) );

} // end function goodz_jetpack_setup
add_action( 'after_setup_theme', 'goodz_jetpack_setup' );

// Remove JP Infinite Scroll module, theme already has it.
function goodz_remove_jp_infinite_scroll( $modules ) {
	if( isset( $modules['infinite-scroll'] ) ) {
		unset( $modules['infinite-scroll'] );
	}

	return $modules;
}
add_filter( 'jetpack_get_available_modules', 'goodz_remove_jp_infinite_scroll' );

/**
 * Change compression quality in Photon
 */
function goodz_custom_photon_compression( $args ) {
	$args['quality'] = 99;
	return $args;
}
add_filter('jetpack_photon_pre_args', 'goodz_custom_photon_compression' );
