<?php
// Add Option page WooCommerce

function filter_woocommerce_settings_tabs_array( $settings_tabs ) {
    $settings_tabs['themes-kingdom'] = __( 'TK - Gallery', 'woocommerce' );

    return $settings_tabs;
}
add_filter( 'woocommerce_settings_tabs_array', 'filter_woocommerce_settings_tabs_array', 99 ); 
 
function action_woocommerce_sections_themes_kingdom() {
    global $current_section;

    $tab_id = 'themes-kingdom';

    $sections = array(
        '' => __( 'Product Gallery', 'woocommerce' ),
    );

    echo '<ul class="subsubsub">';

    $array_keys = array_keys( $sections );

    foreach ( $sections as $id => $label ) {
        echo '<li> <a class="' . ( $current_section == $id ? 'current' : '' ) . '">' . $label . '</a> ' . ( end( $array_keys ) == $id ? '' : '|' ) . ' </li>';
    }

    echo '</ul><br class="clear">';
}
add_action( 'woocommerce_sections_themes-kingdom', 'action_woocommerce_sections_themes_kingdom', 10 );

// Settings function
function get_custom_settings() {
    global $current_section;

    $settings = array();

    if ( $current_section == 'tk-section-1' ) {
        
    } else {
        $settings = array(

            // Title
            array(
                'title'     => __( 'Product gallery style settings', 'woocommerce' ),
                'type'      => 'title',
                'id'        => 'tk_settings_gallery'
            ),

            // Select
            array(
                'title'     => __( 'Gallery style', 'woocommerce' ),
                'desc'      => __( 'Style (Vertical / Horizontal)', 'woocommerce' ),
                'id'        => 'tk_settings_gallery_select',
                'class'     => 'wc-enhanced-select',
                'css'       => 'min-width:300px;',
                'default'   => 'horizontal',
                'type'      => 'select',
                'options'   => array(
                    'vertical'   => __( 'Vertical', 'woocommerce' ),
                    'horizontal' => __( 'Horizontal', 'woocommerce' ),
                ),
                'desc_tip' => true,
            ),

            // Section end
            array(
                'type'      => 'sectionend',
                'id'        => 'tk_settings_gallery'
            ),
        );
    }

    return $settings;
}

// Add settings
function action_woocommerce_settings_themes_kingdom() {
    // Call settings function
    $settings = get_custom_settings();

    WC_Admin_Settings::output_fields( $settings );  
}
add_action( 'woocommerce_settings_themes-kingdom', 'action_woocommerce_settings_themes_kingdom', 10 );

// Process save the settings
function action_woocommerce_settings_save_themes_kingdom() {
    global $current_section;

    $tab_id = 'themes-kingdom';

    // Call settings function
    $settings = get_custom_settings();

    WC_Admin_Settings::save_fields( $settings );

    if ( $current_section ) {
        do_action( 'woocommerce_update_options_' . $tab_id . '_' . $current_section );
    }
}
add_action( 'woocommerce_settings_save_themes-kingdom', 'action_woocommerce_settings_save_themes_kingdom', 10 );

require_once 'product-gallery-slider.php';