<?php
// Product Gallery Thumbnail Carousel

add_image_size('tk_woo_gallery_thumbnail', 122, 122, true);
add_image_size('tk_woo_gallery_large', 800, 800, true);

remove_action( 'woocommerce_product_thumbnails', 'woocommerce_show_product_thumbnails', 20 );

add_action( 'woocommerce_product_thumbnails', 'furnizo_woocommerce_show_product_thumbnails', 20 );
function furnizo_woocommerce_show_product_thumbnails(){
	global $product;
	$attachment_ids = $product->get_gallery_image_ids();
	array_unshift($attachment_ids, get_post_thumbnail_id($product->get_id()));
	$style_layout_gallery = get_option( 'tk_settings_gallery_select' );

	$product_view = ''. $style_layout_gallery .'';
	if($product_view == ''. $style_layout_gallery .''){
		$class="tk_". $style_layout_gallery ."_slider";
	}

	add_action('wp_footer', 'woo_single_page_furnizo_javascript_slider');
	add_action('wp_head', 'woo_single_page_furnizo_css');

	if ( $attachment_ids && $product->get_image_id() ) {
		
		$bottom__sliderhtml = '';

		foreach ( $attachment_ids as $attachment_id ) {
			$gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
			
			//$thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
			$thumbnail_size = apply_filters( 'woocommerce_gallery_thumbnail_size', 'tk_woo_gallery_thumbnail' );

			$thumbnail_src	= wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
			$full_src		= wp_get_attachment_image_src( $attachment_id,'full');
			$image_full		= wp_get_attachment_image($attachment_id,'tk_woo_gallery_large',false,apply_filters('woocommerce_gallery_image_html_attachment_image_params',
					array(
						'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-src'                => esc_url( $full_src[0] ),
						'data-large_image'        => esc_url( $full_src[0] ),
						'data-large_image_width'  => esc_attr( $full_src[1] ),
						'data-large_image_height' => esc_attr( $full_src[2] ),
						'class'                   => esc_attr( 'wp-post-image' ),
					),$attachment_id,'full',false)
			);
			$image = wp_get_attachment_image($attachment_id,$thumbnail_size,false,apply_filters('woocommerce_gallery_image_html_attachment_image_params',
					array(
						'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
						'data-src'                => esc_url( $full_src[0] ),
						'data-large_image'        => esc_url( $full_src[0] ),
						'data-large_image_width'  => esc_attr( $full_src[1] ),
						'data-large_image_height' => esc_attr( $full_src[2] ),
						'data-full_img_data'	=> $image_full,
						'class'                   => esc_attr( 'tk_gallery__image_swiper_thumbnail' ),
					),$attachment_id,$thumbnail_size,false)
			);
		
			$bottom__sliderhtml .= '<div class="woocommerce-product-furnizo_gallery__image swiper-slide">' . $image . '</div>';
		}
	echo '<div thumbsSlider="" class="swiper mySwiper '.$class.'">
				<div class="swiper-wrapper">
				'.$bottom__sliderhtml.'
				</div>
				<div class="swiper-button-prev"></div>
				<div class="swiper-button-next"></div>
			</div>';
		if($product_view == 'vertical'){
			echo '<style>
			.woocommerce-product-gallery__wrapper {
				display: flex;
				flex-direction: row-reverse;
			}
			.woocommerce-product-gallery__image {
				width: 75%;
			}</style>';
		}
	}

}
function wc_get_gallery_image_html_custom( $attachment_id, $main_image = false ) {
	$flexslider        = (bool) apply_filters( 'woocommerce_single_product_flexslider_enabled', get_theme_support( 'wc-product-gallery-slider' ) );
	$gallery_thumbnail = wc_get_image_size( 'gallery_thumbnail' );
	//$thumbnail_size    = apply_filters( 'woocommerce_gallery_thumbnail_size', array( $gallery_thumbnail['width'], $gallery_thumbnail['height'] ) );
	$thumbnail_size		= apply_filters( 'woocommerce_gallery_thumbnail_size', 'tk_woo_gallery_thumbnail' );
	$image_size			= apply_filters( 'woocommerce_gallery_image_size', $flexslider || $main_image ? 'woocommerce_single' : $thumbnail_size );
	$full_size			= apply_filters( 'woocommerce_gallery_full_size', apply_filters( 'woocommerce_product_thumbnails_large_size', 'full' ) );
	$thumbnail_src		= wp_get_attachment_image_src( $attachment_id, $thumbnail_size );
	$full_src			= wp_get_attachment_image_src( $attachment_id, $full_size );
	$alt_text			= trim( wp_strip_all_tags( get_post_meta( $attachment_id, '_wp_attachment_image_alt', true ) ) );
	$image				= wp_get_attachment_image(
		$attachment_id,
		$image_size,
		false,
		apply_filters(
			'woocommerce_gallery_image_html_attachment_image_params',
			array(
				'title'                   => _wp_specialchars( get_post_field( 'post_title', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
				'data-caption'            => _wp_specialchars( get_post_field( 'post_excerpt', $attachment_id ), ENT_QUOTES, 'UTF-8', true ),
				'data-src'                => esc_url( $full_src[0] ),
				'data-large_image'        => esc_url( $full_src[0] ),
				'data-large_image_width'  => esc_attr( $full_src[1] ),
				'data-large_image_height' => esc_attr( $full_src[2] ),
				'class'                   => esc_attr( $main_image ? 'wp-post-image' : '' ),
			),
			$attachment_id,
			$image_size,
			$main_image
		)
	);

	return '<div data-thumb="' . esc_url( $thumbnail_src[0] ) . '" data-thumb-alt="' . esc_attr( $alt_text ) . '" class="woocommerce-product-gallery__image"><a href="' . esc_url( $full_src[0] ) . '">' . $image . '</a></div>';
}
function woo_single_page_furnizo_css(){
    ?>
	<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />
        <style>
			.tk_vertical_slider {
				width: 100%;
				height: 100%;
				width: 20%;
				height: 800px;
				margin-left: auto;
				margin-right: auto;
				box-sizing: border-box;
			}
			.tk_vertical_slider .swiper-slide img {
				display: block;
				width: 100%;
				height: inherit !important;
			}
			.tk_vertical_slider .swiper-slide {
				display: flex;
				padding: 0 0 0 0;
				justify-content: center;
				align-items: center;
				background-size: cover;
				background-position: center;
				width: 100%;
				height: 100%;
				opacity: 1;
			}
			.tk_vertical_slider .swiper-slide-thumb-active {
				opacity: 1;
			}
			.tk_horizontal_slider {
				width: 100%;
				height: 20%;
				box-sizing: border-box;
				padding: 10px 0;
				position: relative;
			}

			.tk_horizontal_slider .swiper-slide {
				text-align: center;
				font-size: 18px;
				background: transparent;
				display: flex;
				justify-content: center;
				align-items: center;
				background-size: cover;
				background-position: center;
				width: 25%;
				height: 100%;
				opacity: 1;
			}
			.tk_horizontal_slider .swiper-slide img {
				display: block;
				width: 100%;
				height: 100%;
				object-fit: cover;
			}
			.tk_horizontal_slider .swiper-slide-thumb-active {
				opacity: 1;
			}
			.tk_horizontal_slider .swiper-button-prev::after, 
			.tk_horizontal_slider .swiper-button-next::after,
			.tk_vertical_slider .swiper-button-prev::after, 
			.tk_vertical_slider .swiper-button-next::after {
				font-size: 30px;
				color: #000000;
			}
			.tk_horizontal_slider .swiper-button-next,
			.tk_horizontal_slider .swiper-button-prev {
				top: 23px;
			}
			.tk_horizontal_slider .swiper-button-prev{
				left: 0;
			}
			.tk_horizontal_slider .swiper-button-next{
				right: 0;
			}

			.woocommerce-product-gallery__wrapper .tk_vertical_slider .swiper-button-next{
			    margin: 0;
			    top: inherit;
			    bottom: 0px;	
			}
			.woocommerce-product-gallery__wrapper .tk_vertical_slider .swiper-button-prev,
			.woocommerce-product-gallery__wrapper .tk_vertical_slider .swiper-button-next{
			    width: 100%;
			    left: 0 !important;
			    background-color: #FFF;
			    opacity: 0.5;
			}
			.woocommerce-product-gallery__wrapper .tk_vertical_slider .swiper-button-prev {
			    margin: 0;
			    top: 0px;
			}
			.woocommerce-product-gallery__wrapper .tk_vertical_slider .swiper-button-prev:after {
			    transform: rotate(90deg) translateX(-50%);
			}
			.woocommerce-product-gallery__wrapper .tk_vertical_slider .swiper-button-next:after{
			    transform: rotate(90deg);
			}

			.woocommerce-product-gallery__wrapper .tk_horizontal_slider .swiper-button-prev,
			.woocommerce-product-gallery__wrapper .tk_horizontal_slider .swiper-button-next{
			    background-color: #FFF;
			    opacity: 0.5;
			    height: 128px;
			    margin-top: 0;
			}

			@media screen and (max-width: 1024px) {
				.tk_vertical_slider{
					height: 450px;
				}
			}

			@media screen and (max-width: 768px) {
				.tk_vertical_slider{
					height: 518px;
				}
			}

			@media screen and (max-width: 640px) {
				.tk_vertical_slider{
					height: 400px;
				}
			}

			.woocommerce div.product div.images .woocommerce-product-gallery__wrapper{
				overflow: hidden;
				position: relative;
			}
			.woocommerce div.product div.images .woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image a:before{
				content: "+";
		        height: 33px;
		        top: .7em;
		        right: .7em;
		        width: 33px;
		        background: var(--wp--custom--color--background);
    			transition: .3s;
    			position: absolute;
    			border-radius: 50%;
    			font-size: 22px;
    			text-align: center;
			}

		</style>
    <?php
}
function woo_single_page_furnizo_javascript_slider() {
    ?>
		<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
        <script>

        	// STYLE HORIZONTAL
			var tk_swiper_h = new Swiper(".tk_horizontal_slider", {
				loop: false,
				spaceBetween: 20,
				slidesPerView: 5,
				freeMode: true,
				centeredSlides: true,
				centeredSlidesBounds: true,
				watchSlidesProgress: true,
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				breakpoints: {
					// 
					640: {
						slidesPerView: 3,
					},
					// when window width is >= 320px
					768: {
						slidesPerView: 4,
					},
					// when window width is >= 480px
					1024: {
						slidesPerView: 4,
					},
					// when window width is >= 640px
					1280: {
						slidesPerView: 5,
					}
				}
			});
			tk_swiper_h.on('transitionStart', function(){
				$imgurl = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('large_image');
				$fullimghtml = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('full_img_data');
				jQuery(".woocommerce-product-gallery__wrapper a").html($fullimghtml);
				jQuery(".woocommerce-product-gallery__wrapper a").attr('href',$imgurl);
				jQuery(".woocommerce-product-gallery__wrapper img.zoomImg").attr("src",$imgurl);
			});

			// STYLE VERTICAL
			var tk_swiper_v = new Swiper(".tk_vertical_slider", {
				loop: false,
				spaceBetween: 20,
				slidesPerView: 5,
				freeMode: true,
				centeredSlides: false,
				centeredSlidesBounds: true,
				watchSlidesProgress: true,
				direction: 'vertical',
				navigation: {
					nextEl: ".swiper-button-next",
					prevEl: ".swiper-button-prev",
				},
				breakpoints: {
					// 
					640: {
						slidesPerView: 3,
					},
					// when window width is >= 320px
					768: {
						slidesPerView: 4,
					},
					// when window width is >= 480px
					1024: {
						slidesPerView: 4,
					},
					// when window width is >= 640px
					1280: {
						slidesPerView: 5,
					}
				}
			});
			tk_swiper_v.on('transitionStart', function(){
				$imgurl = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('large_image');
				$fullimghtml = jQuery('div.swiper-wrapper .swiper-slide:nth-child('+swiper.activeIndex+') img').data('full_img_data');
				jQuery(".woocommerce-product-gallery__wrapper a").html($fullimghtml);
				jQuery(".woocommerce-product-gallery__wrapper a").attr('href',$imgurl);
				jQuery(".woocommerce-product-gallery__wrapper img.zoomImg").attr("src",$imgurl);
			});
			jQuery('document').ready(function($){
				$(".woocommerce-product-gallery--with-images").addClass('tk_style_gallery');
				$(".tk_gallery__image_swiper_thumbnail").click(function(){
					$imgurl = $(this).data('large_image');
					$fullimghtml = $(this).data('full_img_data');
					$(".woocommerce-product-gallery__wrapper img.zoomImg").attr("src",$imgurl);
					$(".woocommerce-product-gallery__wrapper a").html($fullimghtml);
				});
				$(".woocommerce-product-gallery__image").on("click",function(){
					jQuery(".woocommerce div.product div.images .woocommerce-product-gallery__trigger").trigger('click');
				});
			});
			
		</script>
    <?php
}

function tk_remove_image_zoom_support() {
    remove_theme_support( 'wc-product-gallery-zoom' );
}
add_action( 'wp', 'tk_remove_image_zoom_support', 100 );