<?php

function goodz_shop_child_enqueue_styles()
{

	$parent_style = 'goodz-style';

	wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css');
	wp_enqueue_style(
		'child-style',
		get_stylesheet_directory_uri() . '/style.css',
		array($parent_style),
		wp_get_theme()->get('Version')
	);
}
add_action('wp_enqueue_scripts', 'goodz_shop_child_enqueue_styles');

function theme_setup()
{
	add_filter('wpcf7_autop_or_not', '__return_false');
}
add_action('after_setup_theme', 'theme_setup');


add_action('wp_footer', 'script_products_grid');

function script_products_grid() {
    if(is_shop() || is_product_category()) {
        ?>
        <script>
            const buttons = document.querySelectorAll('.buttons-grid .wp-block-button');
            if (buttons) {
                buttons.forEach(button => {
                    button.addEventListener('click', () => {
                        buttons.forEach(x => x.classList.remove('active'));
                        button.classList.add('active');
                    })
                });
            }
        </script>
        <?php
    }
}

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require_once get_stylesheet_directory() . '/inc/template-functions.php';

/**
 * Disable Responsive Images
 */

add_filter( 'wp_calculate_image_srcset', '__return_false' );

/**
 * Improvements
 */

require get_stylesheet_directory() . '/inc/features/load-features.php';