<?php
/**
 * Template Name: Portfolio
 *
 * @package Goodz
 */

get_header();

$paging_type = get_theme_mod( 'paging_setting', 'infinite_scroll' );

// Set pagination
if ( get_query_var( 'paged' ) ) {
	$paged = get_query_var( 'paged' );
}
elseif ( get_query_var( 'page' ) ) {
	$paged = get_query_var( 'page' );
}
else {
	$paged = 1;
}

$args = array(
	'post_type'      => array( 'jetpack-portfolio' ),
	'paged'			 => $paged
);

$wp_query = new WP_Query ( $args );

?>

<div class="container">

	<div class="row">

		<header class="page-header">
			<?php the_title( '<h2 class="page-title">', '</h2>' ); ?>
		</header><!-- .page-header -->

		<div id="primary" class="content-area <?php goodz_content_cols(); ?>">
			<main id="main" class="site-main" role="main">

				<?php if ( post_type_exists( 'jetpack-portfolio' ) && $wp_query->have_posts() ) : ?>

					<div class="row">
						<div class="grid-wrapper clear">
							<?php while ( $wp_query->have_posts() ) : $wp_query->the_post(); ?>

								<?php get_template_part( 'templates/contents/content', get_post_format() ); ?>

							<?php endwhile; ?>
						</div>
					</div>

					<?php wp_reset_postdata(); ?>

					<?php if ( 'infinite_scroll' == $paging_type ) : ?>

						<!-- Infinite load -->
						<?php goodz_is_posts_navigation(); ?>

						<div id="loading-is"></div>

					<?php endif; ?>

				<?php else : ?>

					<section class="no-results not-found">
						<header class="entry-header">
							<h1 class="entry-title"><?php esc_html_e( 'Sorry. Nothing found.', 'goodz' ); ?></h1>
						</header><!-- .page-header -->

						<div class="page-content">
							<?php if ( current_user_can( 'publish_posts' ) ) : ?>

								<p><?php printf( wp_kses( __( 'Ready to publish your first project? <a href="%1$s">Get started here</a>.', 'goodz' ), array( 'a' => array( 'href' => array() ) ) ), esc_url( admin_url( 'post-new.php?post_type=jetpack-portfolio' ) ) ); ?></p>

							<?php else : ?>

								<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'goodz' ); ?></p>
								<?php get_search_form(); ?>

							<?php endif; ?>
						</div><!-- .page-content -->
					</section><!-- .no-results -->

				<?php endif; ?>

			</main><!-- #main -->
		</div><!-- #primary -->

		<?php get_sidebar(); ?>

	</div><!-- .row -->

	<?php if ( 'infinite_scroll' != $paging_type ) : ?>

		<!-- Paging -->
		<?php the_posts_navigation(); ?>

	<?php endif; ?>

</div><!-- .container -->

<?php get_footer(); ?>
