<?php
/**
 * Customize Google Fonts
 *
 * @package Goodz
 */

// Kirki config

Kirki::add_config( 'goodz', array(
	'capability'  => 'edit_theme_options',
	'option_type' => 'option',
	'option_name' => 'goodz',
) );

/* --- Section --- */

// Front Page Slider Section
Kirki::add_section( 'google_fonts_section', array(
	'title'       => esc_html__( 'Font Settings', 'goodz' ),
	'description' => esc_html__( 'Choose fonts for your content', 'goodz' ),
	'panel'    => 'theme_options_panel',
	'priority'    => 119,
) );

/* --- Settings --- */

/* --- Settings --- */
Kirki::add_field( 'goodz', array(
	'type'        => 'typography',
	'settings'    => 'font_paragraph_settings',
	'label'       => esc_attr__( 'Paragraphs', 'goodz' ),
	'section'     => 'google_fonts_section',
	'default'     => array(
		'font-family'    => '"questrial", "Helvetica Neue", Helvetica, Arial, sans-serif',
		'variant'        => 'regular',
		'subsets'        => array( 'latin-ext' ),
	),
	'priority'    => 10,
	'output'      => array(
		array(
			'element' => 'body,.secondary-font, blockquote, .contact-form label, .post .entry-content p, .page .entry-content p, .post .entry-content li, .page .entry-content li, .post .entry-content blockquote, .page .entry-content blockquote, .post .entry-content blockquote p, .page .entry-content blockquote p, .post .entry-meta, .cat-links, .grid-wrapper .product-tag, .wp-caption-text, .widget, .price, .woocommerce-product-details__short-description, .comment-content, .pingback .comment-body > a, .slick-dots, .images .slick-dots button, .home-slider .slick-dots button, .site-header .search-form:after, .author-info p, .post .tkss-post-share > h6, .woocommerce label, .woocommerce .woocommerce-error, .woocommerce .woocommerce-info, .woocommerce .woocommerce-message, .woocommerce-tabs .panel p, .coupon input[type="text"], .select2-drop, div.pp_woocommerce .pp_nav .currentTextHolder, .price, .woocommerce-product-details__short-description, .woocommerce-product-details__short-description, .images .slick-dots button, .woocommerce label, .woocommerce .woocommerce-error, .woocommerce .woocommerce-info, .woocommerce .woocommerce-message, .single .woocommerce-tabs .panel, .coupon input[type="text"], .select2-drop, div.pp_woocommerce .pp_nav .currentTextHolder',
		),
	),
) );

Kirki::add_field( 'goodz', array(
	'type'        => 'typography',
	'settings'    => 'font_heading_settings',
	'label'       => esc_attr__( 'Headings', 'goodz' ),
	'section'     => 'google_fonts_section',
	'default'     => array(
		'font-family'    => '"montserrat", "Helvetica Neue", Helvetica, Arial, sans-serif',
		'variant'        => 'bold',
		'subsets'        => array( 'latin-ext' ),
	),
	'priority'    => 20,
	'output'      => array(
		array(
			'element' => 'h1, h2, h3, h4, h5, h6, blockquote cite, blockquote + cite, blockquote + p cite, .post .entry-content strong, .page .entry-content strong, .home-blog-feed .posted-on .day, .grid-wrapper .format-quote blockquote, .grid-wrapper .format-quote blockquote p, .widget-title, .widget button, .widget input[type="button"], .widget input[type="reset"], .widget input[type="submit"], .home-blog-feed .posted-on .day, .widget_calendar caption, body #jp-relatedposts, .main-shop-nav .mini_cart_item a, .main-shop-nav .cart-widget__wrapper .button, .actions .coupon p, .account-details li, .main-shop-nav .mini_cart_item a, .main-shop-nav .cart-widget__wrapper .button, .actions .coupon p, .account-details li',
		),
	),
) );

Kirki::add_field( 'goodz', array(
	'type'        => 'typography',
	'settings'    => 'font_nav_settings',
	'label'       => esc_attr__( 'Navigation', 'goodz' ),
	'section'     => 'google_fonts_section',
	'default'     => array(
		'font-family'    => '"questrial", "Helvetica Neue", Helvetica, Arial, sans-serif',
		'variant'        => 'regular',
		'subsets'        => array( 'latin-ext' ),
	),
	'priority'    => 30,
	'output'      => array(
		array(
			'element' => '.main-nav-wrap ul li a',
		),
	),
) );
